/********************* (C) COPYRIGHT 2010 e-Design Co.,Ltd. ********************
 File Name : Menu.c  
 Version   : DS203_APP Ver 2.4x                                  Author : bure
*******************************************************************************/
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "Interrupt.h"
#include "Function.h"
#include "Process.h"
#include "Calibrat.h"
#include "File.h"
#include "Menu.h"
#include "Draw.h"
#include "BIOS.h"
#include "USART.h"

typedef uint64_t     u64;

s32 VY;
I32STR_RES Num;
u8 flash_flag=0;
u8 Curr_Status=S_Title,CurrCom,Trigg_CurrCom=0;
u8 display_flag=1;
u8 Notice_Flag=0;
u8 Menu_Flag=0;
u8 filenum[11];
u16 Result_FPS,Standby=6;
u8 ITEM1=0,ITEM2=MENU_ITEM;
u8 MenuItem[11][11]={"Save Param","Save Dat ","Save Buf ","Save Bmp ",
					"Save Csv ","Load Dat ","Load Buf ","BackLight ","Buzzer    ","Standby   ","Calibrat  "};
u8 V_Unit[4][3]={"uV","mV","V ","kV"};
u8 T_Unit[5][3]={"nS","uS","mS","S ","  "};
u8 F_Unit[5][5]={"!Hz!","!Hz!","KHz","MHz","    "};

uc8 STATESTR[2][10] = {"!RUN!", "HOLD"};                          // Running state str

uc16 S_Inv[2]       = {(SCRN<<4)+TEXT2, (SCRN<<4)+NOTE1};         // Running state Color

uc8 BATT_STR[5][10] = {"~``'", "~``}", "~`;}", "~;;}", "{;;}"};   // Battery Status Str
uc16 B_COLOR[5]     = {(NOTE1<<4)+SCRN, (SIDE <<4)+SCRN,
                       (TEXT2<<4)+SCRN, (TEXT2<<4)+SCRN,
                       (TEXT2<<4)+SCRN};                          // Battery Status Color

uc8 CH_A_STR[2][10]  = {" -- ", "!CH(A)!"};
uc8 CH_B_STR[2][10]  = {" HIDE ", "!CH(B)!"};
uc8 CH_C_STR[2][10]  = {" -- ", "CH(C)"};
uc8 CH_D_STR[10][10] = {"! -- !", "CH(D)", "(A+B)", "(A-B)",  
                     "(C&D)", "(C|D)", "REC_A",  "REC_B",
                        "REC_C",  "REC_D"};                      // Track source Str
uc8 NO_RANGE[5]      = " -- ";                       
uc8 NO_DEF[5]        = " -- ";                       

uc8  YCOUPLE[3][10]  = {" -- "," AC ", " DC "};                        // Track Couple Str!---!                    
u8   Vertical[15][10];                                             // Track Range Str
uc8  YPOSISTR[5]    = {" Y "};  //SCRN  YPOS

uc16 Y_INV[6]       = {(SCRN<<4)+TR_1,  (SCRN<<4)+TR_2,
                       (SCRN<<4)+TR_3,  (SCRN<<4)+TR_4,
                       (SCRN<<4)+VERNIE,(SCRN<<4)+X_POSI};                          // Track Color 1
uc16 Y_COLOR[6]     = {(TR_1<<4)+SCRN, (TR_2<<4)+SCRN,
                       (TR_3<<4)+SCRN, (TR_4<<4)+SCRN,
                       (VERNIE<<4)+SCRN,(X_POSI<<4)+SCRN};                          // Track Color 2

uc8 MODESTR[5][10]  = {"!AUTO!", "!NORM!", "SINGL", "!NONE!",
                       "SCAN!"};                                  // Sync Mode Str
u8   BaseStr[30][10];                                              // Time Base b Str
uc8  XPOSISTR[5]    = {" X  "};//XPOS
uc8  TPOSISTR[5]    = {"!T0 "};//T XPOS
uc8  XBUFSTR[5][5]		={"360",".5K","!1K!","!2K!","!4K!"};//X-BUF PAGE
uc16 XCOLOR[2]      = {(SCRN<<4)+X_POSI, (X_POSI<<4)+SCRN};        // Time Base Color 

uc8 FO_TYPE[4][10]  = {"SIN!",  "Tri!",  "Saw!",  "Squ!"}; // Output Kind Str  "Kd=  %"
//uc8 FO_TYPE[4][10]  = {" SINE ",  "Triang",  " !Saw! ",  "Square"}; 
uc8 FO_STR[20][10]  = {" 10Hz ",  " 20Hz ",  " 50Hz ",   " 100Hz",
                       "!200Hz!", "!500Hz!", " 1KHz ",   " 2KHz ",
                       " 5KHz ",  "!10KHz!", "!20KHz!",  "!50KHz!",
                       "100KHz",  "200KHz",  "500KHz",   " 1MHz ",
                       " 2MHz ",  " 4MHz ",  " 6MHz ",   " 8MHz "}; // Output Frequency Str
//uc8 FO_DUTY[10][10]={  "DUT 20% "," DUT 30% "," DUT 40% ","DUT 50% "," DUT 60% "," DUT 70% "," DUT 80% "," DUT 90% "};
uc8 FO_DUTY[10][10]={  "DUT 90% "," DUT 80% "," DUT 70% ","DUT 60% "," DUT 50% "," DUT 40% "," DUT 30% "," DUT 20% "," DUT 10% "};
uc16 O_COLOR[2]     = {(SCRN<<4)+TEXT3, (TEXT3<<4)+SCRN};         // Output Frequency Color

uc8  TRIGSTR[8][10] = {"TRI", "TRI", "TRI", "TRI" };     // Trigger source Str
                          
uc8  TR_TYPE[8][5] = {":!\\!", ":!^!", "<Vt", ">Vt",            // Trigger Type Str
                       "<TL",   ">TL",  "<TH", ">TH"};
                      

                        
uc8  VT_STR[5]      =  "THR";                                // Trigg Voltage StrESHOL
                          
uc8  VERNIE1[5]     = {"!V1!"};          // V1 Vernie Str
uc8  VERNIE2[5]     = {"!V2!"};          // V2 Vernie Str
uc8  VERNIE3[5]     = {"!T1!"};          // T1 Vernie Str
uc8  VERNIE4[5]     = {"!T2!"};          // T2 Vernie Str
uc8  EXT_STR[2][5]  = {"EXT","SAV"};

u8 THR[]={"T:  "};
u8 ITEM_V[2][5]={"V1:  ","V2:  "};
uc8 ITEM_T[2][5]={"T1:  ","T2:  "};
uc16 V_INV[1]       = {(SCRN<<4)+VERNIE};
uc16 V_COLOR[1]     = {(VERNIE<<4)+SCRN};                         // Y Vernie Color
uc16 T_INV[1]       = {(SCRN<<4)+VERNIE};
uc16 T_COLOR[1]        = {(VERNIE<<4)+SCRN};                         // X Vernie Color
uc8  F_FUNC[2][10]  = {"Save File", "Load File"};                 // File Function Str

uc8  F_EXT[8][10]   = {".BMP?", ".DAT?", ".BUF?",".CSV?", " OK! ",
                         " ERR!",".HEX", ".BIN",};                  // File Ext Name Str
uc16 F_INV[1]       = {(SCRN<<4)+TEXT1};                          //  File Color
uc8  DELTA_V[2][10] = {"[V:", "[V:"};
uc8  DELTA_T[4]     = "[T:";
uc8  METER[14][5]   = {"Vbt", "FPS","Vpp", "Vdc", "RMS",  "Max", "Min", "FRQ", 
                       "CIR", "DUT", "!TH!", "!TL!","EXT","SAV"};

u8   NumStr[9], Detail[14];
u8   Current = 0, TypeA = 0, Update = 1;
u8   BL_Str[5]="B.L", Vol_Str[5]="Vol", Standby_Str[5]="   ";
u8 Current1 = 13;
menu Title[13][4]=   
{
  //     Item_String,   m_Color,   Limit, Mark, xPos, yPos, Value, Flag 
  {//============================ Title Track1 Group ===========================
    {(u8*)YCOUPLE, (u16*)Y_INV,     3-1, CIRC,   36,  228,     2, UPDAT}, //  Track Couple  Y_COLOR     
    {(u8*)Vertical,(u16*)Y_COLOR,   8-1,    0,   36,  216,     5, UPDAT}, //  Track Range  
    {(u8*)YPOSISTR,(u16*)Y_INV,   195-1,  NOT,   332, 228,   150, UPDAT}, //  Adj. Track Position 160
    {(u8*)CH_A_STR,(u16*)Y_INV,     2-1,  NOT,    0,    0,     1,   HID}, //  Track source
  },
  {//============================ Title Track2 Group ===========================
    {(u8*)YCOUPLE, (u16*)Y_INV+1,   3-1, CIRC,   71,  228,     2, UPDAT}, //  Track Couple   Y_COLOR     
    {(u8*)Vertical,(u16*)Y_COLOR+1, 8-1,    0,   71,  216,     5, UPDAT}, //  Track Range
    {(u8*)YPOSISTR,(u16*)Y_INV+1, 195-1,  NOT,   332, 228,   100, UPDAT}, //FIX  Adj. Track Position
    {(u8*)CH_B_STR,(u16*)Y_INV+1,   2-1,  NOT,    0,    0,     1,   HID},   //  Track source
  },
  {//============================ Title Track3 Group ===========================
    {(u8*)CH_C_STR,(u16*)Y_INV+2,   2-1, CIRC,  106,  228,     1, UPDAT}, //  Track source
    {(u8*)NO_RANGE,(u16*)Y_COLOR+2, 1-1,    0,  106,  216,     0, UPDAT}, //  Track Range
    {(u8*)YPOSISTR,(u16*)Y_INV+2, 200-1,  NOT,  332,  228,    60, UPDAT}, // FIX Adj. Track Position
    {(u8*)NO_DEF , (u16*)Y_COLOR+2, 1-1,  NOT,    0,    0,     0,   HID}, //  Track Couple 
   
  },
  {//============================ Title Track4 Group ===========================
    {(u8*)CH_D_STR,(u16*)Y_INV+3,  10-1, CIRC,  141,  228,     1, UPDAT}, //  Track source
    {(u8*)NO_RANGE,(u16*)Y_COLOR+3, 1-1,    0,  141,  216,     0, UPDAT}, //  Track Range
    {(u8*)YPOSISTR,(u16*)Y_INV+3, 200-1,  NOT,  332,  228,    10, UPDAT}, //FIX  Adj. Track Position
    {(u8*)NO_DEF , (u16*)Y_COLOR+3, 1-1,  NOT,    0,    0,     0,   HID}, //  Track Couple    
  },
  {//================== Running State & Battery Status Group ===================
    {(u8*)STATESTR,(u16*)S_Inv,     2-1,    0,    1,  228,     0, UPDAT}, //  Running state
    {(u8*)BATT_STR,(u16*)B_COLOR,   5-1,    0,    0,  216,     0, UPDAT}, //  Battery status
    {(u8*)BATT_STR,(u16*)B_COLOR,   5-1,  NOT,    0,  216,     0,   HID}, 
    {(u8*)BATT_STR,(u16*)B_COLOR,   5-1,  NOT,    0,  216,     0,   HID},
  },
  {//========================= Title Time Base Group ===========================
    {(u8*)MODESTR, (u16*)XCOLOR,    5-1, CIRC,  184,  228,     0, UPDAT}, //  Sync Mode
    {(u8*)BaseStr, (u16*)XCOLOR+1, 27-1,    0,  184,  216,    17, UPDAT}, //  Time Base Range
    {(u8*)XPOSISTR,(u16*)XCOLOR,   	136,  	NOT,  216,  216,     0, UPDAT}, //  FIXAdj. X position
    {(u8*)XPOSISTR,(u16*)XCOLOR,   	136,  	NOT,  	80,   0,     0, UPDAT}, //  View window rule3795CIRC
  },           
  {//======================= Title Output Signal Group =========================
    {(u8*)FO_TYPE, (u16*)O_COLOR,   4-1, CIRC,  227,  228,     3, UPDAT}, //  Output Wave Kind      
    {(u8*)FO_STR,  (u16*)O_COLOR+1,20-1,    0,  282,  228,    13, UPDAT}, //  Output Frequency         
    {(u8*)FO_DUTY, (u16*)O_COLOR,  9-1,  DUTV,  334,  228,    4, UPDAT},      //ռձ  
    {(u8*)NumStr,  (u16*)O_COLOR,     0,  NOT,    0,    0,     0,   HID}, //  Duty value 
       
  },
 /* {//=====================;===== Title Trigger Group ====;======================
    {(u8*)TRIGSTR, (u16*)Y_INV,     4-1, CIRC,  294,  188,     1, UPDAT}, //  Trigger source         
    {(u8*)TR_TYPE, (u16*)Y_INV,     8-1, CIRC,  344,  188,     0, UPDAT}, //  Trigger Kine         
    {(u8*)VT_STR,  (u16*)Y_INV,     200,  FIX,  294,  172,     0, UPDAT}, //  Adj. Trigger threshold  Y_COLOR   
    {(u8*)VT_STR,  (u16*)Y_INV,       0,  NOT,  294,  172,     0, HID}, //  Number position   HID NOT    
  },
  {//============================ Title Y Vernie Group =========================
    {(u8*)VERNIE1, (u16*)V_INV,   200-1,  FIX,  294,  156,   180, UPDAT}, //  V1 Vernie         
    {(u8*)VERNIE2, (u16*)V_INV,   200-1,  FIX,  294,  140,    40, UPDAT}, //  V2 Vernie     
    {(u8*)DELTA_V, (u16*)Y_INV,     2-1, CIRC,  334,  156,     0, UPDAT}, //  Measure Track    
    {(u8*)NumStr,  (u16*)Y_INV,     240, NUM3,  334,  140,    70, UPDAT}, //  Delta V value 
     
  },
  {//============================ Title X Vernie Group =========================
    {(u8*)VERNIE3, (u16*)T_INV,     300,  FIX,  294,   124,    80, UPDAT}, //  T1 Vernie         
    {(u8*)VERNIE4, (u16*)T_INV,     300,  FIX,  294,   108,   280, UPDAT}, //  T2 Vernie     
    {(u8*)DELTA_T, (u16*)T_INV,       0,  NOT,  334,   124,     0, UPDAT}, //  Delta T Str     
    {(u8*)NumStr,  (u16*)T_INV,     300, NUM3,  334,   108,    80, UPDAT}, //  Delta T value  T_COLOR  
  },
  {//============================= Title File Group ============================
    {(u8*)F_FUNC,  (u16*)F_INV,     2-1, CIRC,  134,    0,     0,     0}, //  File function    
    {(u8*)NumStr,  (u16*)F_INV,   256-1, NUM3,  206,    0,     0,     1}, //  File number     
    {(u8*)F_EXT,   (u16*)F_INV,     4-1, CIRC,  230,    0,     0,     0}, //  Ext. name     
    {(u8*)F_EXT,   (u16*)F_INV,       0,  NOT,    0,    0,     0,   HID},  
  },
  
  {//=========================== Title BackLight Group =========================
    {(u8*)BL_Str,  (u16*)V_INV,     1-1,  FIX,  314,  167,     0, UPDAT}, //  BackLight    
    {(u8*)NumStr,  (u16*)V_COLOR,  10-1, NUM2,  342,  167,     5, UPDAT}, //  Class     
    {(u8*)NumStr,  (u16*)V_INV,       0,  NOT,    0,    0,     0,   HID},     
    {(u8*)NumStr,  (u16*)V_INV,       0,  NOT,    0,    0,     0,   HID},  
  },
  {//============================ Title Volume Group ===========================
    {(u8*)Vol_Str, (u16*)V_INV,     1-1,  FIX,  314,  152,     0, UPDAT}, //  Volume        
    {(u8*)NumStr,  (u16*)V_COLOR,  11-1, NUM2,  342,  152,     5, UPDAT}, //  Class     
    {(u8*)NumStr,  (u16*)V_INV,       0,  NOT,    0,    0,     0,   HID},    
    {(u8*)NumStr,  (u16*)V_INV,       0,  NOT,    0,    0,     0,   HID},    
  },*/
};

meter Meter[9] =
{ 
  {(u8*)METER,      4,    VBT,     340,    370,   148,  UPDAT}, //  Meter #1
  {(u8*)METER, TRACK4,    FRQ,     340,    370,   132,  UPDAT}, //  Meter #2   FPS 
  {(u8*)METER, TRACK3,    CIR,     340,    370,   116,  UPDAT}, //  Meter #3    
  {(u8*)METER, TRACK3,    DUT,     340,    370,   100,  UPDAT}, //  Meter #4       
  {(u8*)METER, TRACK2,    TH,      340,    370,    84,  UPDAT}, //  Meter #5
  {(u8*)METER, TRACK2,    TL,      340,    370,    68,  UPDAT}, //  Meter #6
  {(u8*)METER, TRACK1,    VPP,     340,    370,    52,  UPDAT}, //  Meter #7
  {(u8*)METER, TRACK1,    VDC,     340,    370,    36,  UPDAT}, //  Meter #8
  {(u8*)METER,      4,    Ext,     340,    370,    20,  UPDAT}, //  Exit
};         

trigger Trigg[18]=
{//========================== Title Trigger Group ===========================  
  //Item: String,  Ttack,  yPos, xPos,  Limit1, Limit2, Value1, Value2, Flag 
//===============  ======  ====  =====  ======  ======  ======   =====  =====
    {(u8*)TR_TYPE, TRACK1, 188,   376,    0,      8-1,      0,      0,  UPDAT},  //  Trigger Kine 
    {(u8*)VT_STR,  TRACK1, 172,   376,    5,    200-5,    170,      0,  UPDAT}, //  Adj. Trigger threshold  Y_COLOR  
//============================ Title Y Vernie Group =========================
    {(u8*)VERNIE1, TRACK1, 156,   376,    2,    200-2,    160,      0,  UPDAT}, //  V1 Vernie   2      
    {(u8*)VERNIE2, TRACK1, 140,   376,    2,    200-2,     40,      0,  UPDAT}, //  V2 Vernie 	3
//============================ Title X Vernie Group =========================        
    {(u8*)VERNIE3,      5, 124,   376,    2,    360-2,     80,      0,  UPDAT}, //  T1 Vernie   4     
    {(u8*)VERNIE4,      5, 108,   376,    2,    360-2,    280,      0,  UPDAT}, //  T2 Vernie 	5
//============================ Title YPOS XPOS ===================================    
    {(u8*)YPOSISTR,TRACK1,  92,   376,    2,    200-2,    150,      0,  UPDAT}, //  Adj. Y Position 160  6  
    {(u8*)XPOSISTR,     5,  76,   376,  127,    360-2,      0,      0,  UPDAT}, //  Adj. X position				7
    {(u8*)TPOSISTR,     5,  60,   376,  	0,    3-1,    		0,     	0,  UPDAT}, //  Adj. T0 Xposition			8
		{(u8*)XBUFSTR,     	5,  44,   376,  	0,    5-1,    	  0,     	4,  UPDAT}, //  Adj. PAGE BUF Xposition ITEM=09
//----------------------------Exit--------------------------------------------------         
    {(u8*)EXT_STR,      4,  28,   376,    0,  2-1,      0,      0,  UPDAT}, //  EXt Item 10
//-----------------------------------------------------------------------------                   
   
//----------------------------------------------------------------------------------------------------
    {(u8*)DELTA_V, TRACK1, 0,   2,    0,      2-1,      0,      0,  UPDAT}, //  Measure Track    
    {(u8*)NumStr,  TRACK1, 0,   24,    0,      240,     70,   NUM3,  UPDAT}, //  Delta V value 
                                           
    {(u8*)DELTA_T,      5, 0,   86,    0,        0,      0,    0,     UPDAT}, //  Delta T Str     
    {(u8*)NumStr,       5, 0,   110,    0,      300,      80,  NUM3,  UPDAT}, //  Delta T value  T_COLOR 
    
  //==========================================================================
//=========================== Title BackLight Group =========================
    {(u8*)BL_Str,       4,  92,   286,    0,        9,      5,      0, UPDAT}, //  BackLight 15
//============================ Title Volume Group ===========================     
    {(u8*)Vol_Str,      4,  76,   286,    0,       9,      5,      0, UPDAT}, //  Volume 16
//============================ Title Volume Group ===========================     
    {(u8*)Standby_Str,  0,  0,   0,    0,       30,      10,      0, UPDAT}, //  Volume 17

};

#define DAT   0
#define BUF   1
#define BMP   2
#define CSV   3
//12 item

sysmenu Menus[]=
{ //----Item name---- filetype--flag---
  {(u8*)MenuItem,      0,       UPDAT}, //  Meter #1
  {(u8*)MenuItem,      1,       UPDAT}, //  Meter #1
  {(u8*)MenuItem,      2,       UPDAT}, //  Meter #1
  {(u8*)MenuItem,      3,       UPDAT}, //  Meter #1
  {(u8*)MenuItem,      4,       UPDAT}, //  Meter #1
  {(u8*)MenuItem,      5,       UPDAT}, //  Meter #1
  {(u8*)MenuItem,      6,       UPDAT}, //  Meter #1
  {(u8*)MenuItem,      7,       UPDAT}, //  Meter #1
	{(u8*)MenuItem,      8,       UPDAT},
	{(u8*)MenuItem,      9,       UPDAT},
	{(u8*)MenuItem,     10,       UPDAT},
};  
void Update_Trigg(void)
{
  u8  i,track;
  s32  k, n, m;
 
   __LCD_DMA_Ready(); 
  for(i=0; i<15; i++)
  {  
    track=Trigg[i].Track;
   
    if(Trigg[i].Flag & UPDAT)                 //-----ʾˢµĴĿ
    { 
      Trigg[i].Flag =0;

     switch(i){
        case  0:
           Trigg[1].Flag |= UPDAT;
           Print_Map(
            Trigg[i].XPOS, Trigg[i].YPOS,         // Ҫʾ
            Y_INV[track],                          // Ҫʾɫ(ͨ)
            PRN,                                   // Ҫʾķʽ
            Trigg[i].Value2+5);
            //(Trigg[i].Str+(Trigg[i].Value2 *5)));    // ҪʾĿ
          break;
        case 2:
        case 3: 
          Trigg[11].Track=Trigg[2].Track;
          Print_Str(
            Trigg[i].XPOS, Trigg[i].YPOS,        
            Y_INV[track],                          
            PRN,                                   
            (Trigg[i].Str+(Trigg[i].Value2 *5))); 
          if(track<2){
            Trigg[11].Flag =UPDAT; 
            Trigg[12].Flag =UPDAT; 
          }
          break;
 
        case 4:
        case 5:
          Print_Str(
            Trigg[i].XPOS, Trigg[i].YPOS,         // Ҫʾ
            Y_INV[track],                          // Ҫʾɫ(ͨ)
            PRN,                                   // Ҫʾķʽ
            (Trigg[i].Str+(Trigg[i].Value2 *5)));    // ҪʾĿ
          Trigg[14].Flag =UPDAT; 
        break; 
     case   12:
       Int32String_sign(&Num,(_V1_Vernie - _V2_Vernie)*(Y_Attr[Title[Trigg[2].Track][RANGE].Value].SCALE));//_Meas_V_Scale )
       Print_Str(
          Trigg[i].XPOS, Trigg[i].YPOS,
          Y_INV[Trigg[3].Track],     // Color fixed  Title[i][j].Color[_Meas_V_Track]
          PRN, 
          Num.str);                                // String for numerical
      Print_Str(
          Trigg[i].XPOS+40, Trigg[i].YPOS,
          Y_INV[Trigg[3].Track],      // Color fixed  Trigg[i][j].Color[_Meas_V_Track]
          PRN, 
          V_Unit[Num.decPos]);                     // String variable
     break;
     case 14:     //T_VERNIE
        {  
          m = 1;  n = 1;
          k = _T_Range;
          if(k < 9)  m = pow(10, (11-k)/3);
          else       n = pow(10, (k- 9)/3);
          k = X_Attr[(k%3)+9].SCALE *(_T2 - _T1);
          if(k > 0)
          { if(k <=  0x7FFFFFFF/m)  k = (m * k)/n;
            else                    k = 0x80000000;
          } 
          else 
          {
            if((-k)> 0x7FFFFFFF/m)  k = (m * k)/n;
            else                    k = 0x80000000;
          }
          Int32String_sign(&Num, k);//((_T2 - _T1)*X_Attr[k].SCALE)/n);
//              Int32String_sign(&Num, m*(k *(_T2 - _T1)/n));//((_T2 - _T1)*X_Attr[k].SCALE)/n);
          Print_Str(
                Trigg[i].XPOS, Trigg[i].YPOS,
                Y_INV[track],                   // Color fixed Title[i][j].Color[0], 
                PRN, 
                Num.str                                // String for numerical
              );
              Print_Str(
                Trigg[i].XPOS + 40, Trigg[i].YPOS,
                Y_INV[track],                   // Color fixed Title[i][j].Color[0], 
                PRN,
                T_Unit[Num.decPos]                     // String variable
              );
          }
      break;
      default:
           Print_Str(
              Trigg[i].XPOS, Trigg[i].YPOS,         // Ҫʾ
              Y_INV[track],                          // Ҫʾɫ(ͨ)
              PRN,                                   // Ҫʾķʽ
              (Trigg[i].Str+(Trigg[i].Value2 *5)));    // ҪʾĿ
        break; 
      }//switch end
    }
  }

  if((CurrCom > 0)&&(CurrCom <= TRIGG_EXT))
  {//-----ʾ˸ĲĿ
      Print_Str(
      Trigg[CurrCom].XPOS, Trigg[CurrCom].YPOS,          // Ҫ˸ 
      Y_INV[Trigg[CurrCom].Track],                           // Ҫ˸ɫ(ͨ)
      Twink,                                  // ˸ʽ
      (Trigg[CurrCom].Str +(Trigg[CurrCom].Value2 *5)));    // Ҫ˸Ŀ
  }
  if((CurrCom == 0) && (Curr_Status==S_Trigg))
  {//-----ʾ˸ĲĿ
      Print_Map(
      Trigg[CurrCom].XPOS, Trigg[CurrCom].YPOS,          // Ҫ˸ 
      Y_INV[Trigg[CurrCom].Track],                           // Ҫ˸ɫ(ͨ)
      Twink,                                  // ˸ʽ
      Trigg[CurrCom].Value2+5 );    // Ҫ˸Ŀ
  }
  Display_Value(0);
   __LCD_DMA_Ready();
}



void ShowMenu(void)
{
  u16 i;
  u8 color,type;
  u8 str[4];
    BLOCK_HIDE=0;
    for(i=0;i<1500;i++) Block[i]=0;
    Bx2 = 300;Bx1 =Bx2-6*16;  
    By1 = 6; By2 =By1+(menu_item+1)*16;
    NoteSide(2); 
    for(i=0; i<menu_item; ++i)
    {       
      Nx0=4; Ny0 =(menu_item-i)*16-6;
      if(i==CurrCom){color=1;type=1;}
      else {color=2;type=0;}
      NoteSTR(color, type,(Menus[i].Str+Menus[i].Item*11));
      if((i>0)&&(i<menu_item) && (i==CurrCom)) //
      {   memset(str,0,3);
          sprintf((char*)str,"%02d" ,filenum[CurrCom]);
          Nx0=4+5*14; Ny0 =(menu_item-i)*16-6;
          NoteSTR(color, type,str);
      }
    }
  Draw_Window();
  __LCD_DMA_Ready();
}
        
void show_notice(void)
{
  u16 i;
  u8 color,type;
  if(Notice_Flag==0)
  { BLOCK_HIDE=1;
     Draw_Window();
    __LCD_DMA_Ready();
    return;
  }
    BLOCK_HIDE=0;
    for(i=0;i<1500;i++) Block[i]=0;
    Bx1 =360-6*16-8; Bx2 = 360; 
    By1 = 2; By2 =By1+9*16;
    NoteSide(2); 
    for(i=0; i<8; ++i)
    { type=1;       
      Nx0=4; Ny0 =(8-i)*16-4;//(u8*)&METER[i][0]
      color=Meter[i].Track;
      color++;
      if(color>3){color=3;type=0;}
      NoteSTR(color, type,(Meter[i].Str+Meter[i].Item*5));
    }
   Draw_Window();
  __LCD_DMA_Ready();
}
void Display_Meter(void)                  // ÿˢʾһ
{
  u8  i;
  for(i=0; i<9; ++i){        
    if(Meter[i].Flag & UPDAT){            //-----ʾˢµĲĿ
     Meter[i].Flag =0;
      Print_Str
        (Meter[i].XPOS1, Meter[i].YPOS,        // Ҫʾ
         Y_INV[Meter[i].Track],                // Ҫʾɫ(ͨ)
         PRN,                                  // Ҫʾķʽ
         (Meter[i].Str +(Meter[i].Item * 5)));   // ҪʾĿ
    } 
  }
//  if((CurrCom >= METER_0)&&(CurrCom <= METER_8))
  if(CurrCom <= METER_8)
  {//-----ʾ˸ĲĿ
      i = CurrCom;
      Print_Str(
      Meter[i].XPOS1, Meter[i].YPOS,         // Ҫ˸ 
      Y_INV[Meter[i].Track],                 // Ҫ˸ɫ(ͨ)
      Twink,                                 // ˸ʽ
      (Meter[i].Str +(Meter[i].Item *5)));     // Ҫ˸Ŀ
  }
}
//              0-ns        3-us                       12--ms                     21--1s
const int Ts[]={100,200,500,1,2,5,10,20,50,100,200,500,1,2,5,10,20,50,100,200,500,1};
const int Kps[]={246,492,614,819,983,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024};
void Display_Value(u8 i)
{
  s32 Tmp = 0;
  u8* Ptr;
  u8  Offset= 40;
  u8  DUT_STR[5] = "%  ";
  u8  FPS_STR[6] = "/Sec.";
  u16 Kp;
  u32 k, n, m;
  u64 FTmp=0,sv,su,skp,sk;
  //u8 str[10];
  if(Interlace == 0) Kp = _Kp1; // ģʽ
  else               Kp = _Kp2; // ģʽ  
  k = _T_Range;
  m = 1;  n = 1;
  sk=21-k;
  sv=Ts[sk];
  skp=Kps[sk];
  if(sk<3)su=1000000000;
  else
    { if(sk<12)su=1000000;
      else{if(sk<21)su=1000;
      else su=1;}
      }
  if(k < 9)  m = pow(10, (11-k)/3);
  else       n = pow(10, (k- 9)/3);
  k = X_Attr[(k%3)+9].SCALE;
  switch (Meter[i].Item){  
  case VBT://--------------- ʾصѹ ---------------
    Tmp = __Get(V_BATTERY)* 1000;
    Int32String_sign(&Num, Tmp);
    Ptr = V_Unit[Num.decPos];
    break;
  case FPS://--------------- ʾ֡ ---------------
    Tmp = Result_FPS & 0x7F;
    Int32String(&Num, Tmp, 2);
    Ptr = FPS_STR;
    Offset = 16;
    break;  
  case VPP:
    if(Meter[i].Track == TRACK1)//&&(_1_source == CH_A))
      Tmp = (Ka1[_A_Range] +(Ka2[_A_Range]*a_Vpp + 512)/1024)* Y_Attr[_A_Range].SCALE;
    if(Meter[i].Track == TRACK2)//&&(_2_source == CH_B))
      Tmp = (Kb1[_B_Range] +(Kb2[_B_Range]*b_Vpp + 512)/1024)* Y_Attr[_B_Range].SCALE;
	  Int32String_sign(&Num, Tmp);
    Ptr = V_Unit[Num.decPos];
    break;
  case VDC:
    if(Meter[i].Track == TRACK1)//&&(_1_source == CH_A))
      Tmp = (Ka1[_A_Range] +(Ka2[_A_Range]*a_Vdc + 512)/1024)* Y_Attr[_A_Range].SCALE;
    if(Meter[i].Track == TRACK2)//&&(_2_source == CH_B))
      Tmp = (Kb1[_B_Range] +(Kb2[_B_Range]*b_Vdc + 512)/1024)* Y_Attr[_B_Range].SCALE;
    Int32String_sign(&Num, Tmp);
    Ptr = V_Unit[Num.decPos];
    break;
  case RMS:
    if(Meter[i].Track == TRACK1)//&&(_1_source == CH_A))
      Tmp = (Ka1[_A_Range] +(Ka2[_A_Range]*Int_sqrt(a_Ssq/4096)+ 512)/1024)* Y_Attr[_A_Range].SCALE;
    if(Meter[i].Track == TRACK2)//&&(_2_source == CH_B))
      Tmp = (Kb1[_B_Range] +(Kb2[_B_Range]*Int_sqrt(b_Ssq/4096)+ 512)/1024)* Y_Attr[_B_Range].SCALE;
    Int32String_sign(&Num, Tmp);
    Ptr = V_Unit[Num.decPos];
    break;
  case MAX:
    if((Meter[i].Track == TRACK1)&&((a_Vdc != 0)||(a_Vpp != 0)))//&&(_1_source == CH_A)
      Tmp = (Ka1[_A_Range] +(Ka2[_A_Range]*a_Max + 512)/1024 - _1_posi)* Y_Attr[_A_Range].SCALE;
    if(Meter[i].Track == TRACK2)//&&(_2_source == CH_B))
      Tmp = (Kb1[_B_Range] +(Kb2[_B_Range]*b_Max + 512)/1024 - _2_posi)* Y_Attr[_B_Range].SCALE;
    Int32String_sign(&Num, Tmp);
    Ptr = V_Unit[Num.decPos];
    break;
  case MIN:
    if((Meter[i].Track == TRACK1)&&((a_Vdc != 0)||(a_Vpp != 0)))//&&(_1_source == CH_A)
      Tmp = (Ka1[_A_Range] +(Ka2[_A_Range]*a_Min + 512)/1024 - _1_posi)* Y_Attr[_A_Range].SCALE;
    if(Meter[i].Track == TRACK2)//&&(_2_source == CH_B))
      Tmp = (Kb1[_B_Range] +(Kb2[_B_Range]*b_Min + 512)/1024 - _2_posi)* Y_Attr[_B_Range].SCALE;
    Int32String_sign(&Num, Tmp);
    Ptr = V_Unit[Num.decPos];
    break;
  case FRQ:
    if(Meter[i].Track == TRACK1)//&&(_1_source == CH_A))// Tmp = 2000*((500000 * a_Tcnt)/a_Tcs);
    { 
      if((a_Tcnt<10) || (a_Tcs/a_Tcnt<5)) FTmp=0;
      else{ 
        FTmp=a_Tcnt*30;
        FTmp=FTmp*su*skp;
        FTmp=FTmp/sv/a_Tcs/1024;
      }
/*        Word2Hex(Num.str, a_Tcnt);
        Print_Str(0, 0, Y_COLOR[0], PRN, Num.str);
        Word2Hex(Num.str, a_Tcs);
        Print_Str(300, 0, Y_COLOR[0], PRN, Num.str);*/

    } 
    if(Meter[i].Track == TRACK2)//&&(_2_source == CH_B))//Tmp = 2000*((500000 * b_Tcnt)/b_Tcs);
    {  
      if((b_Tcnt<10) || (b_Tcs/b_Tcnt<5)) FTmp=0;
      else{ 
        FTmp=b_Tcnt*30;
        FTmp=FTmp*su*skp;
        FTmp=FTmp/sv/b_Tcs/1024;
      }
    } 
    if(Meter[i].Track == TRACK3)//&&(_3_source == CH_C))//Tmp = 2000*((500000 * c_Tcnt)/c_Tcs);
    { if((c_Tcnt<10) || (c_Tcs/c_Tcnt<5)) FTmp=0;
      else{  
      FTmp=c_Tcnt*30;
      FTmp=FTmp*su*skp;
      FTmp=FTmp/sv/c_Tcs/1024;
      }
    }      
    if(Meter[i].Track == TRACK4)//&&(_4_source == CH_D))// Tmp = 2000*((500000 * d_Tcnt)/d_Tcs);
    {
      if((d_Tcnt<10) || (d_Tcs/d_Tcnt<5)) FTmp=0;
      else{  
        FTmp=d_Tcnt*30;
        FTmp=FTmp*su*skp;
        FTmp=FTmp/sv/d_Tcs/1024;
      }
    }
    Tmp=FTmp;
    dectostr(Num.str,&Num.decPos, Tmp); 
    Ptr=F_Unit[Num.decPos];
    break;  
  case CIR:
    if(Meter[i].Track == TRACK1)//&&(_1_source == CH_A))
      Tmp = (k * a_Tcs)/a_Tcnt;
    if(Meter[i].Track == TRACK2)//&&(_2_source == CH_B))
      Tmp = (k * b_Tcs)/b_Tcnt;
    if(Meter[i].Track == TRACK3)//&&(_3_source == CH_C))
      Tmp = (k * c_Tcs)/c_Tcnt;
    if(Meter[i].Track == TRACK4)//&&(_4_source == CH_D))
      Tmp = (k * d_Tcs)/d_Tcnt;
    if(Tmp <= 0x7FFFFFFF/m) Tmp = (m*((1024 * Tmp)/Kp))/n;
    else                    Tmp = 0x80000000;
    Int32String(&Num, Tmp, 4);
    Ptr = T_Unit[Num.decPos];
    break;
  case DUT:
    if(Meter[i].Track == TRACK1)												//&&(_1_source == CH_A))
      Tmp = ((100000*a_Pws)/a_Pcnt)/(a_Tcs/a_Tcnt);
    if(Meter[i].Track == TRACK2)												//&&(_2_source == CH_B))
      Tmp = ((100000*b_Pws)/b_Pcnt)/(b_Tcs/b_Tcnt);
    if(Meter[i].Track == TRACK3)												//&&(_3_source == CH_C))
      Tmp = ((100000*c_Pws)/c_Pcnt)/(c_Tcs/c_Tcnt);
    if(Meter[i].Track == TRACK4)												//&&(_4_source == CH_D))
      Tmp = ((100000*d_Pws)/d_Pcnt)/(d_Tcs/d_Tcnt);
    Int32String(&Num, Tmp, 4);
    Ptr = DUT_STR;
    break;
  case TL:
    if(Meter[i].Track == TRACK1)//Tmp = (k * a_Tcs)/a_Tcnt;											//&&(_1_source == CH_A))
      Tmp = (k*a_Tcs)/a_Tcnt - (k*a_Pws)/a_Tcnt;
    if(Meter[i].Track == TRACK2)// Tmp = (k * b_Tcs)/b_Tcnt;										//&&(_2_source == CH_B))
      Tmp = (k*b_Tcs)/b_Tcnt - (k*b_Pws)/b_Tcnt;
    if(Meter[i].Track == TRACK3)//&&(_3_source == CH_C))//Tmp = (k * c_Tcs)/c_Tcnt;
     Tmp = (k*c_Tcs)/c_Tcnt - (k*c_Pws)/c_Tcnt; 
    if(Meter[i].Track == TRACK4)//&&(_4_source == CH_D)) Tmp = (k * d_Tcs)/d_Tcnt;
     Tmp = (k*d_Tcs)/d_Tcnt - (k*d_Pws)/d_Tcnt;
    if(Tmp <= 0x7FFFFFFF/m) Tmp = (m*((1024 * Tmp)/Kp))/n;
    else                    Tmp = 0x80000000;
    Int32String(&Num, Tmp, 4);
    Ptr = T_Unit[Num.decPos];
    break;
  case TH:
    if(Meter[i].Track == TRACK1)//&&(_1_source == CH_A))Tmp = (k * a_Tcs)/a_Tcnt;
      Tmp = (k*a_Pws)/a_Tcnt;
    if(Meter[i].Track == TRACK2)//&&(_2_source == CH_B))Tmp = (k * b_Tcs)/b_Tcnt;
      Tmp = (k*b_Pws)/b_Tcnt;
    if(Meter[i].Track == TRACK3)//&&(_3_source == CH_C))Tmp = (k * c_Tcs)/c_Tcnt;
      Tmp = (k*c_Pws)/c_Tcnt;
    if(Meter[i].Track == TRACK4)//&&(_4_source == CH_D))Tmp = (k * d_Tcs)/d_Tcnt;
      Tmp = (k*d_Pws)/d_Tcnt;
    if(Tmp <= 0x7FFFFFFF/m) Tmp = 1024*((m*Tmp)/Kp)/n;
    else                    Tmp = 0x80000000;
    Int32String(&Num, Tmp, 4);
    Ptr = T_Unit[Num.decPos];
    break;
    }
    if(Notice_Flag==Meter_Flag)
    {
       Nx0=4+8*4; Ny0 =(8-i)*16-4;
       NoteSTR(2, 0, Num.str);
       Nx0=(36+Offset); Ny0 =(8-i)*16-4;
       NoteSTR(2, 0, Ptr);
    }
    if(i==0)
    {  Print_Str(
      200, 0,
      Y_COLOR[Meter[0].Track], 
      PRN,
      Num.str);                              // ʾֵ
      Print_Str(
      (200 + Offset), 0,
      Y_COLOR[Meter[0].Track], 
      PRN,
      Ptr);                 // ʾ
    }
}
void ExitMeter(u8 Item)
{
  Curr_Status=S_Title;
   switch (Item)
  { 
    case 1:
      Notice_Flag &=(~Meter_Flag);
      BLOCK_HIDE=1;
      break;
    case 2:
      Trigg[CurrCom].Flag |=UPDAT;
      Trigg_CurrCom=CurrCom;
      CurrCom=15;
      Update_Trigg();
      break;
    case 3:
      Menu_Flag =0;
      BLOCK_HIDE=1;
     break;
    default:
      break;      
  }
  display_flag=1;
  Draw_Window();
  __LCD_DMA_Ready();  
}

void SetMeter(u8 Item)
{u32 j;
  u8 i;
  switch(Item){
    case 1:
      BLOCK_HIDE=0;
      for(j=0;j<1500;j++) Block[j]=0;  
      display_flag=0;
      Curr_Status=S_Meter;
      CurrCom=METER_0;
      Meter[CurrCom].Flag= UPDAT;
      Bx1 =360-5*8; Bx2 = 360; 
      By1 = 4; By2 =By1+9*16;
      NoteSide(1); 
      Draw_Window();
      __LCD_DMA_Ready();
      for(i=0; i<9; ++i)
      {        
        Print_Str
        ( Meter[i].XPOS1, Meter[i].YPOS,        // Ҫʾ
          Y_INV[Meter[i].Track],                // Ҫʾɫ(ͨ)
          PRN,                                  // Ҫʾķʽ
          (Meter[i].Str +(Meter[i].Item * 5))   // ҪʾĿ
        );   
      }
      
    break; 
    case 2:
      Curr_Status=S_Trigg;
      CurrCom=Trigg_CurrCom;
      Trigg[CurrCom].Flag|= UPDAT;
      _Curr[_Det].Flag|=UPDAT;
      flash_flag=1;
      Show_Title();
      flash_flag=0;
   break;
   case 3:
      Curr_Status=S_Menu;
      CurrCom=0;
      Menus[CurrCom].Flag|= UPDAT;
      
    break;
   }//switch end
}


void Display_Trigg(void)
{u8 i=0;
	
	Print_Map(
			Trigg[i].XPOS, Trigg[i].YPOS,        // Ҫʾ
      Y_INV[Trigg[i].Track],                // Ҫʾɫ(ͨ)
      PRN,
      Trigg[i].Value2+5);                                  // Ҫʾķʽ
  for(i=1; i<12; i++)
  {  
    Print_Str( 
      Trigg[i].XPOS, Trigg[i].YPOS,        // Ҫʾ
      Y_INV[Trigg[i].Track],                // Ҫʾɫ(ͨ)
      PRN,                                  // Ҫʾķʽ
      (Trigg[i].Str +(Trigg[i].Value2 *5)));   // ҪʾĿ
  }
  Update_Trigg();
}
void Show_Title(void)
{
  u8 i,j,Color_fixed,type;


  __LCD_DMA_Ready();
  for(i=0;i<MENU_ITEM;i++)//MENU_ITEM
  {
    for(j=0;j<3;j++)
    {
      if(Title[i][j].Flag & UPDAT)
      {   // ҪˢµItem
        Title[i][j].Flag =0;// ~UPDAT;   // Clr Update flag 
				if(flash_flag==0)
        {	
					if((Current == i)&&(Detail[i] == j))
          	type=Twink;
        	else 
          	type=PRN;
				}
				else
							type=PRN;
        if((i==4)&&(j==0))
          Color_fixed=_State.Value;
        else 
          Color_fixed=0;
        if(i<4)Show[i]=Title[i][0].Value;
         switch (Title[i][j].MARK){ 
          case FIX: 
            Print_Str(
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[Color_fixed],                   
              type, 
              Title[i][j].Str);
          break;
         case DUTV:
           Print_Str(
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[Color_fixed],                   
              type, 
              Title[i][j].Str+(Title[i][j].Value * 10));
             break;
         // case NOT:
          case 0:
          case CIRC:
          	Print_Str(
              Title[i][j].XPOS, Title[i][j].YPOS,
              Title[i][j].Color[Color_fixed],                    // Color fixed 
              type, 
              Title[i][j].Str +(Title[i][j].Value * 10));
          	if((i==6)&&(j==0))
          	{
          		Print_CharMap(
              Title[i][j].XPOS+3*8+4, Title[i][j].YPOS,
              Title[i][j].Color[Color_fixed],                    // Color fixed 
              type, 
              Title[i][j].Value);
            }
            
          break;
        }//switch end
     }
   }//for j end
 }//FOR I END

 Print_Str(
 174, 0,           											// Ҫʾx=200 y=0
 Y_INV[Meter[0].Track],                // Ҫʾɫ(ͨ)
 PRN,                                  // Ҫʾķʽ
 (Meter[0].Str +(Meter[0].Item * 5)));   // ҪʾĿ
 Display_Value(0);
 
}           

/*******************************************************************************
 Load_Attr:  Ӳ
*******************************************************************************/
void Load_Attr(void)
{
  u16 i;
  
  for(i=0; i<G_Attr[0].Yp_Max+1; ++i) 
    strcpy((char*)&Vertical[i][0], (char*)Y_Attr[i].STR);
  Title[TRACK1][RANGE].Limit = G_Attr[0].Yp_Max;
  Title[TRACK2][RANGE].Limit = G_Attr[0].Yp_Max;
  Title[TRACK3][RANGE].Limit = 0;
  Title[TRACK4][RANGE].Limit = 0;
  
  for(i=0; i<G_Attr[0].Xp_Max+6; ++i) 
    strcpy((char*)&BaseStr[i][0], (char*)X_Attr[i].STR);
  Title[T_BASE][BASE].Limit = G_Attr[0].Xp_Max;
  
}
/*******************************************************************************
 Update_Battery:  ˢµصָʾ
*******************************************************************************/
void Update_Battery(void)
{
  u16 Vb, Level;
  
  Vb = __Get(V_BATTERY);
  Level =0;
  if(Vb > 3000 ) Level +=1;
  if(Vb > 3500 ) Level +=1;
  if(Vb > 3900 ) Level +=1;
  if(Vb > 4100 ) Level +=1;
  Print_Str(
    Title[4][1].XPOS, Title[4][1].YPOS,
    Title[4][1].Color[Level], 
    PRN,
    (Title[4][1].Str + Level*10) 
  );    
}

void process_menu(void)
{int rc=0;
  switch (CurrCom){
  case 0:
    __Display_Str(266, 0, YEL, PRN, "Parameter Save");
    rc=Save_Param();
    break;
  case 1:
    __Display_Str(268, 0, YEL, PRN, "Save Dat");
    rc=Save_Dat(filenum[1]);
    break;
  case  2:
    __Display_Str(268, 0, YEL, PRN, "Save Buf");
    rc=Save_Buf(filenum[2]);
    break;
  case  3:
    __Display_Str(268, 0, YEL, PRN, "Save Image");
    BLOCK_HIDE=1;
    display_flag=1;
    Draw_Window();
    __LCD_DMA_Ready();  
    rc=Save_Bmp(filenum[3]);
    BLOCK_HIDE=0;
    display_flag=0;
    Draw_Window();
    __LCD_DMA_Ready();  
    break;
  case  4:
    __Display_Str(268, 0, YEL, PRN, "Save Csv  ");
    rc=Save_Csv(filenum[4]);
    break;
  case  5:
    __Display_Str(268, 0, YEL, PRN, "Load Dat...");
    rc=Load_Dat(filenum[5]);
    break;
  case  6:
    __Display_Str(268, 0, YEL, PRN, "Load Buf...");
    rc=Load_Buf(filenum[6]);
    Show_Title();
  
    break;
  case  7:		//set backlight
		Trigg[BK_LIGHT].Value1=filenum[7];
		__Set(BACKLIGHT, 10*(Trigg[BK_LIGHT].Value1+1));
    Show_Title();
		return;
  case  8:		//set buzzer
		Trigg[VOLUME].Value1=filenum[8];
 		__Set(BEEP_VOLUME, 5*Trigg[VOLUME].Value1);
 	  Show_Title();
		return;

  case  9:		//set standby time
		Standby=filenum[9];
		PD_Cnt=Standby*Unit;
    Show_Title();
		return;
  case  10:
    ExitMeter(3);
    Calibrat(filenum[10]);
    return;
  } 
  if(rc!=OK)
  {   __Display_Str(266, 0, YEL, PRN, "Load File Fail!");
      Delayms(2000);
  }
  else
  {  Delayms(500);
		 if((CurrCom<7)||(CurrCom==10))filenum[CurrCom]++;
  }
  __Display_Str(264, 0, YEL, PRN, "                ");
  ShowMenu();     

}

void display_Vernie_item(void)
{
  
  Int32String_sign(&Num,(_V1_Vernie - _V2_Vernie)*(Y_Attr[Title[Trigg[2].Track][RANGE].Value].SCALE));
  Print_Str(
    Trigg[12].XPOS, Trigg[12].YPOS,
    Y_INV[Trigg[2].Track],     // Color fixed  Title[i][j].Color[_Meas_V_Track]
    PRN, 
    Num.str);                                // String for numerical
    Print_Str(
      Trigg[12].XPOS+40, Trigg[12].YPOS,
      Y_INV[Trigg[2].Track],      // Color fixed  Trigg[i][j].Color[_Meas_V_Track]
      PRN, 
      V_Unit[Num.decPos]);    
}
void display_Tbase_item(void)
{
    s32  k, n, m;
    m = 1;  n = 1;
    k = _T_Range;
    if(k < 9)  m = pow(10, (11-k)/3);
    else       n = pow(10, (k- 9)/3);
    k = X_Attr[(k%3)+9].SCALE *(_T2 - _T1);
    if(k > 0)
    { if(k <=  0x7FFFFFFF/m)  k = (m * k)/n;
      else                    k = 0x80000000;
    } 
    else 
    {
      if((-k)> 0x7FFFFFFF/m)  k = (m * k)/n;
      else                    k = 0x80000000;
    }
    Int32String_sign(&Num, k);//((_T2 - _T1)*X_Attr[k].SCALE)/n);
    Print_Str(
        Trigg[14].XPOS, Trigg[14].YPOS,
        Y_INV[5],                   // Color fixed Title[i][j].Color[0], 
        PRN, 
        Num.str                                // String for numerical
    );
    Print_Str(
        Trigg[14].XPOS + 40, Trigg[14].YPOS,
        Y_INV[5],                   // Color fixed Title[i][j].Color[0], 
        PRN,
        T_Unit[Num.decPos]                     // String variable
    );    
}
void display_item(u8* str,s32 value,u8 item)
{
 
	Print_Str(
		276, 0,
		Y_INV[Trigg[item].Track],     
  		PRN, 
		str); 
	Int32String_sign(&Num,value);
	Print_Str(
		290, 0,
        Y_INV[Trigg[item].Track],     
 		PRN, 
 		Num.str);
 		if(item<4)
 	{
		Print_Str(
 			330, 0,
			Y_INV[Trigg[item].Track],      // Color fixed  Trigg[i][j].Color[_Meas_V_Track]
			PRN, 
			V_Unit[Num.decPos]);
	}
	else
	{
		Print_Str(
 			330, 0,
			Y_INV[Trigg[item].Track],      // Color fixed  Trigg[i][j].Color[_Meas_V_Track]
			PRN, 
			T_Unit[Num.decPos]);
	}	     
}

/******************************** END OF FILE *********************************/
